%
% Create Example 5.4 of the book
%
% Dongrui WU (dongruiw@usc.edu), 11/16/2008
%

warning off all
clear all;
close all;
clc;

%% get the FOUs
[words,MFs]=getFOUs();

%% -------- Plot the ordered interval type-2 word models in a single figure ----
%% Plot the ordered interval type-2 word models
figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',11);
set(gcf,'DefaultaxesFontSize',10);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
for i=1:32
    subplot(8,6,2*floor((i-1)/4)+i);
    fill(MFs(i,[1:4 8 7 6 5 1]),[0 1 1 0 0 MFs(i,9) MFs(i,9) 0 0],[0.9 0.9 0.9]);
    hold on;
    plot(MFs(i,1:4),[0 1 1 0],'k');
    plot(MFs(i,5:8),[0 MFs(i,9) MFs(i,9) 0],'k');
    title(words(i,:),'fontsize',10);
    set(gca,'YTick',[]);
    set(gca,'XTick',[]);
    axis([0 10 0 1]);
end

Xs=[4 11 20]; %[tiny,little, sizeable]
Ws=[9 16 26]; %[small, medium, large]
LWA=LWA(MFs(Xs,:),MFs(Ws,:)); %% LWA
for i=1:size(words,1)
    S(i)=Jaccard(LWA,MFs(i,:));
end
[maxS,index]=max(S);
decode=words(index,:)  %% decoding
maxS

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',11);
set(gcf,'DefaultaxesFontSize',10);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
subplot(5,2.5,1)
N=length(Xs);
for i=1:N
    fill(MFs(Xs(i),[1:4 8:-1:5]),[0 1 1 0 0 MFs(Xs(i),[9 9]) 0],[0.9,0.9,0.9]);
    hold on
end
for i=1:N
    plot(MFs(Xs(i),[1:4 8:-1:5]),[0 1 1 0 0 MFs(Xs(i),[9 9]) 0]);
    text(MFs(Xs(i),2)+.9, 1.15, words(Xs(i),:),'horizontalalignment','center');
end
axis([0,11,0,1.4]);
set(gca,'xtick',[0:10]);
box off
text(11.2,0,'x');
%text(0.2,1.33,'u');
arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.4],0.06,pi/10,0.5,[0 0 0],'-');
saveas(gcf,'Fig5-13a.eps');

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',11);
set(gcf,'DefaultaxesFontSize',10);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
subplot(5,2.5,1)
for i=1:N
    fill(MFs(Ws(i),[1:4 8:-1:5]),[0 1 1 0 0 MFs(Ws(i),[9 9]) 0],[0.9,0.9,0.9]);
    hold on
end
for i=1:N
    plot(MFs(Ws(i),[1:4 8:-1:5]),[0 1 1 0 0 MFs(Ws(i),[9 9]) 0]);
    text(mean(MFs(Ws(i),2:3)), 1.18, words(Ws(i),:),'horizontalalignment','center');
end
axis([0,11,0,1.4]);
set(gca,'xtick',[0:10]);
box off
text(11.2,0,'w');
text(0.2,1.33,'u');
arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.4],0.06,pi/10,0.5,[0 0 0],'-');
saveas(gcf,'Fig5-13b.eps');

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',11);
set(gcf,'DefaultaxesFontSize',10);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
subplot(5,2.5,1)
fill(LWA([1:4 8:-1:5]),[0 1 1 0 0 LWA([9 9]) 0],[0.9,0.9,0.9]);
hold on
fill(MFs(index,[1:4 8:-1:5]),[0 1 1 0 0 MFs(index,[9 9]) 0],[0.9,0.9,0.9]);
plot(LWA([1:4 8:-1:5]),[0 1 1 0 0 LWA([9 9]) 0]);
plot(MFs(index,[1:4 8:-1:5]),[0 1 1 0 0 MFs(index,[9 9]) 0],'w-');
plot(MFs(index,[1:4 8:-1:5]),[0 1 1 0 0 MFs(index,[9 9]) 0],'--');
axis([0, 11, 0, 1.4]);
text('Interpreter','latex','String','$$\widetilde{Y}_{LWA}$$','Position',[mean(LWA(2:3)),1.2],'horizontalalignment','center');
axis([0,11,0,1.4]);
set(gca,'xtick',[0:10]);
box off
text(11.2,0,'y');
text(0.2,1.3,'u');
arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.4],0.06,pi/10,0.5,[0 0 0],'-');
saveas(gcf,'Fig5-13c.eps');

